//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Stage 1.0

ShaderEffect {
    id : effect

    property vector2d offset : Qt.vector2d(0, 0)
    property alias    source : patternSrc.source

    readonly property SharedImage pattern : patternSrc
    readonly property vector2d patternScale :
        Qt.vector2d(patternSrc.nativeWidth /  Math.max(1, effect.width),
                    patternSrc.nativeHeight / Math.max(1, effect.height))

    anchors.centerIn : parent

    SharedImage {
        id : patternSrc

        visible : false
    }

    vertexShader : "
        attribute mediump vec4 qt_Vertex;
        attribute mediump vec2 qt_MultiTexCoord0;

        uniform mediump mat4 qt_Matrix;

        uniform mediump vec2 patternScale;
        uniform mediump vec2 offset;

        varying mediump vec2 v_TexCoord;

        void main() {
            gl_Position = qt_Matrix * qt_Vertex;
            v_TexCoord  = qt_MultiTexCoord0 / patternScale + offset;
        }"

    fragmentShader : "
        varying mediump vec2 v_TexCoord;

        uniform lowp float qt_Opacity;

        uniform sampler2D pattern;

        void main() {
            gl_FragColor = texture2D(pattern, v_TexCoord) * qt_Opacity;
        }"
}
